<?php $__env->startSection('title', 'Testimonials'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Testimonials</h1>
    <a href="<?php echo e(route('admin.testimonials.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Testimonial
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($testimonials->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Author</th>
                        <th>Content</th>
                        <th>Rating</th>
                        <th>Order</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($testimonial->author); ?></td>
                        <td><?php echo e(Str::limit($testimonial->content, 80)); ?></td>
                        <td>
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <i class="bi bi-star<?php echo e($i <= $testimonial->rating ? '-fill text-warning' : ''); ?>"></i>
                            <?php endfor; ?>
                        </td>
                        <td><?php echo e($testimonial->sort_order); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($testimonial->is_active ? 'success' : 'secondary'); ?>">
                                <?php echo e($testimonial->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.testimonials.show', $testimonial)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.testimonials.edit', $testimonial)); ?>" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="<?php echo e(route('admin.testimonials.destroy', $testimonial)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this testimonial?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No testimonials yet. <a href="<?php echo e(route('admin.testimonials.create')); ?>">Add your first testimonial</a>.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/testimonials/index.blade.php ENDPATH**/ ?>